/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.password;

import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;

public class PasswordBean
extends PanelBean {
    private String m_sNewPasswordEdit;
    private String m_sConfirmPasswordEdit;
    private String m_sOldPasswordEdit;
    boolean m_bEnforcePassword = false;
    boolean caseSensitive = false;
    boolean oldRequired;
    UserTaskManager _utm;

    public PasswordBean(boolean oldPWRequired) {
        this.oldRequired = oldPWRequired;
    }

    public void setNewPasswordEdit(String s) throws IllegalUserDataException {
        this.m_sNewPasswordEdit = s;
    }

    public String getNewPasswordEdit() {
        return this.m_sNewPasswordEdit;
    }

    public void setConfirmPasswordEdit(String s) throws IllegalUserDataException {
        this.m_sConfirmPasswordEdit = s;
    }

    public String getConfirmPasswordEdit() {
        return this.m_sConfirmPasswordEdit;
    }

    public void setOldPasswordEdit(String s) throws IllegalUserDataException {
        this.m_sOldPasswordEdit = s;
    }

    public String getOldPasswordEdit() {
        return this.m_sOldPasswordEdit;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void setUTM(UserTaskManager utm) {
        this._utm = utm;
    }

    public UserTaskManager getUTM() {
        return this._utm;
    }

    public void prepare() {
        this.setUTM(this.userTaskManager);
        if (this.oldRequired) {
            this.userTaskManager.setEnabled("OldPasswordEdit", true);
        } else {
            this.userTaskManager.setEnabled("OldPasswordEdit", false);
        }
    }

    public void load() {
        this.m_sNewPasswordEdit = null;
        this.m_sConfirmPasswordEdit = null;
        this.m_sOldPasswordEdit = null;
    }

    public void save() {
    }

    public void panelAction(TaskActionEvent event) {
        boolean result = true;
        String command = event.getElementName();
        PanelTaskletRequest request = new PanelTaskletRequest();
        if (command.equals("OkButton")) {
            UserTaskManager utm = (UserTaskManager)event.getSource();
            utm.storeAllElements();
            if (this.oldRequired && !(result = this.verifyOldPasswordLengths())) {
                return;
            }
            result = this.verifyPasswordLengths();
            if (!result) {
                return;
            }
            result = this.verifyConfirmPasswordLengths();
            if (!result) {
                return;
            }
            result = this.verifyPasswordEquality();
            if (!result) {
                return;
            }
            request.setData("action", "setpassword");
            request.setData("password", this.m_sNewPasswordEdit);
            request.setData("oldpassword", this.m_sOldPasswordEdit);
            this.postTaskletRequest(request);
        } else if (command.equalsIgnoreCase("CancelButton")) {
            request.setCanceled();
            this.postTaskletRequest(request);
        } else {
            this.dispose();
        }
    }

    public boolean verifyPasswordEquality() {
        boolean result = true;
        if (!this.getNewPasswordEdit().equals(this.getConfirmPasswordEdit())) {
            try {
                BaseMessageTitle title = new BaseMessageTitle("HACA8004");
                BaseMessageText msg = new BaseMessageText("HACA0004");
                CommonMsgApp.showMessageBox(this.getUserTaskManager(), title, msg);
            }
            catch (Exception exception) {
                // empty catch block
            }
            result = false;
        }
        return result;
    }

    public boolean verifyPasswordLengths() {
        boolean result = true;
        if (this.getNewPasswordEdit() == null || this.getNewPasswordEdit().length() < 1) {
            try {
                BaseMessageTitle title = new BaseMessageTitle("HACA8003");
                BaseMessageText msg = new BaseMessageText("ADM0024");
                CommonMsgApp.showMessageBox(this.getUserTaskManager(), title, msg);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return result;
    }

    public boolean verifyConfirmPasswordLengths() {
        boolean result = true;
        if (this.getConfirmPasswordEdit() == null || this.getConfirmPasswordEdit().length() < 1) {
            try {
                BaseMessageTitle title = new BaseMessageTitle("HACA800M");
                BaseMessageText msg = new BaseMessageText("ADM0024");
                CommonMsgApp.showMessageBox(this.getUserTaskManager(), title, msg);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return result;
    }

    public boolean verifyOldPasswordLengths() {
        boolean result = true;
        if (this.getOldPasswordEdit() == null || this.getOldPasswordEdit().length() < 1) {
            try {
                BaseMessageTitle title = new BaseMessageTitle("HACA800N");
                BaseMessageText msg = new BaseMessageText("ADM0024");
                CommonMsgApp.showMessageBox(this.getUserTaskManager(), title, msg);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return result;
    }
}

